report-errors npm module
========================
# Description
This module provides useful process wide error handling and reporting mechanisms for any Node.js based process. Currently tested on Windows, should be compatible with posix platforms, but is not tested. 

The basics are that there is a error reporter object which allows you to add and remove reporting channels, and to report an error to all of them, safely, asynchronously or synchronously, with full error handling and reporting the results.  The whole thing is built on ES6 promises. 

# Getting the module
This package is published to the vsts internal npm repo. Please refer to their documentation for setting this up. Once you are set up, all you need to do is add this package as a dependency and run npm install, as with any other package.

# Requirements
To use this module, you must be either building ES6 or using type information like ES6-shim. The interface relies on Promises and Typescript will not build it if it cannot find the needed types. This type information must be available to the compiler either in a triple slash reference or by giving a definition file to the compiler as an input. No additional ambient definitions are needed to use this, but any issues you have with building are likely not having these types available. Don't trust VS Code's type error messages until you get a successful build from the command line and restart it. 

This is tested against Node 6.x. but should be widely compatible. 

It is cross platform and should work as intended on Windows, Mac OS, and Linux. It is tested on Windows 10 and Ubuntu 14.

Usage
-----
# Basic
For basic functionality, simply use the members exporter from the module directly. These include the following classes and interfaces:
*`ErrorHandlerNode`
Handles uncaught exceptions for the whole process, processes them to remove PII, and then reports them to any reporting channels the user registers using the `addReportingChannel` method. 
The constructor takes a single object with a series of properties. 
-`appRoot: string`
    -required
    -Must be an absolute path to the root of the app. Paths in the the processed stack trace will be stripped to be relative to this path.
    -if an empty string is passed, paths will be stripped to just filenames. You must explicitly pass this in. 
    
-`packageInfo: {name: string, version: string, branch?: string}`
    -required, but can have only a name
    -gives the app the name, version, and branch to uniquely identify the code that is running in error reports
    -you can JSON.parse or require your package.json and pass it here to avoid hardcoding versions, etc.
    -default values will not let you distinguish crash reports by version and might even keep you from distinguishing your package from others using the defaults. 

-`finalCallback?: (err: Error) => boolean`
    -optional, default behavior is usually correct
    -allows you to control how the app handles uncaught errors after they have been reported
    -if you do not provide a callback or your callback returns false, the app is killed. this is usually the behavior you want.
    -if you do provide a callback and that callback returns true, the app continues running
    -I recommend the default behavior in production, but swallowing errors can be useful in debugging
   
-`exeName?: string`
    -optional, only use if needed
    -overrides the real exe name for reporting channels that use it
    -useful if you share an executable with another package or your executable has a very generic name like Node or Electron

This class also emits events (wrapped in typesafe functions) during certain conditions. You can subscribe by calling the wrapped functions with your event handler. 

`public onAsyncFailure(callback: (asyncError: Error) => void): void`
Your callback will be called if one of the reporting channels fails asyncronously while trying to report an error. Due to the nature of JS async frameworks, it is impossible to determine what code scheduled the work
and therefore to blame a specific reporting channel and have it reject its promise. You can use this event to do this or just to be aware that the code is buggy. By default, reporting channels have a .5 seond timeout, and will reject.

`public onUserCallbackUncaughtException(callback: (uncaughtException: Error) => void): void` 
Emits if the callback above throws an uncaught exception. Mostly informational. Errors thrown by this handler will be swallowed and ignored.  

`public onInternalError(callback: (internalError: InternalErrorDetails) => void): void` 
Emits when an error occurs within the error handling code. May or may not be fatal. Will be reported by an internal error reporter in the future. 
If your reports are not going through, be sure to subscribe to this and let the author know. The parameter splits it up into PII and non PII properties of the internal error. 

`public onReportingFinished(callback: (results: PromiseResults) => void): void`
Emits when all reporting channels have succeeded, failed, or timed out. Passes the results to the subscribers.

*`ConsoleReporter` 
A reporting channel that simply prints the raw stack to the console. 

*`FileReporter`
A reporting channel that appends the stack trace to a given file path and name. The last parameter determines whether the raw stack trace or a processed one with PII removed is written. 

# Advanced
By directly importing "report-errors/advanced" you can get access to all the interfaces and classes needed to implement your own Reporting channels, as well as useful error processing and reporting utilities. 

*`ErrorReporter`
Only has the functionality of adding/removing channels and reporting to them. It does not have any side effects like handling uncaught exceptions process wide, which makes it good for reporting non fatal errors. 
Will only emit when reporting finishes or when an internal error occurs. Async uncaught exceptions will not be handled (they can only go the uncaught exception handler) so be especially careful about these if you use custom reporting channels. The interface is the same as the node version but without callbacks. Reporting channels will still time out. 

*`ReportingChannel` abstract class
The abstract class you must extend to make custom error reporting channels. Allows you to override the default timeout and opt into rejections being emitted as internal errors. 
I recommend implementing a constructor and not exposing the parent class constructor. The only thing you must implement, however, is the report method, which takes an ErrorInformation object and returns a promise that resolves when that error has been reported.
These can be used independantly of the Error Reporter class. 

*`ErrorInformation`
Takes an error object several optional parameters. Handles all processing and PII removal. A required parameter of the ReportingChannel interface. Can be used independently. 

*others
There are various interfaces that the ErrorInformation API relies on and several useful methods for general string, path, and stack trace processing. 

Contributing
------------
I am open to suggestions, bugfixes, and pull requests. If you want to make a topic branch and develop this, Here are the development steps:
*clone the repo
*run npm install
*run typings install
*edit (VS Code recommended)
*run gulp build, tslint, clean, and test as required
*run gulp validate-for-publish to do all of these, plus, generating a tarball that can be published or used for local testing. It is in the lib folder. 


Notes
-------------
Why do I need to provide an absolute path? Why can't I give a relative path?
I, the developer, could allow relative paths, but the question is: relative to what?
It is usually the intention that it be relative to the file calling the constructor, but I am not able to reliably get that location. I can use module.parent, but that breaks with derived classes.
The alternative is to use the current working directory, but this leads to unexcepted behavior if the cwd is changed for some reason or if it is launched differently thatn expected. 
Since the whole goal is to make stack traces installation location agnostic, we need a consistent root directory. Therefore, I have decided to not accept relative paths at all. 

This requires slightly more code by the consumer of my APIs, but it can be very simple. 
If you want to define the app root relative to the file you are in, get it by using path.resolve(__dirname, "../relative/path"). This is the way I recommend. If the file is in the root folder, just pass in __dirname.
If you really insist on it being relative to the cwd, just use path.resolve("./relative/path") and it will find that path relative to the cwd. 

If this is inconsistent, you may end up with paths that sometimes look like "app/main/index.js" and sometimes look like "main/index.js", 
or worse, the cwd will be somewhere completely different and your paths will get stripped all the way to the filename, so if there is more than one index.js file that would have been distinguished by folder structure, you now cannot tell them apart.
If you introduce inconsistencies like this, it becomes impossible for automated systems to tell that a crash originating in "app/main/index.js" is the same as one in "main/index.js". 
Everyone's life will be easier if you just provide an absolute path that you get by resolving relative the directory your file is in. 

As one more note, never provide the root of the drive ("/" on *nix, "X:\" on windows). This will strip only that off of paths and you will get essentially full paths that are not installation location independent and which could contain usernames, which are PII. 
You should provide as specific a path as possible while still encompassing all of your app's code. You do not need to encompass node_modules, as processing of these stack frames is handled separately. 